SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS, NOCOUNT ON
GO
SET DATEFORMAT YMD
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO
BEGIN TRANSACTION

TRUNCATE TABLE [hipsui].[Sex]

SET IDENTITY_INSERT [hipsui].[Sex] ON
INSERT [hipsui].[Sex] ([SexId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, N'Male', N'Male', CAST(0x0000A23F00000000 AS DateTime), N'Admin', CAST(0x0000A23F00000000 AS DateTime), N'Admin')
INSERT [hipsui].[Sex] ([SexId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, N'Female', N'Female', CAST(0x0000A13900000000 AS DateTime), N'Admin', CAST(0x0000A13900000000 AS DateTime), N'Admin')
INSERT [hipsui].[Sex] ([SexId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, N'IntersexOrIndeterminate', N'Intersex', CAST(0x0000A13900000000 AS DateTime), N'Admin', CAST(0x0000A13900000000 AS DateTime), N'Admin')
SET IDENTITY_INSERT [hipsui].[Sex] OFF

TRUNCATE TABLE [hipsui].[IdentityVerificationMethod]

SET IDENTITY_INSERT [hipsui].[IdentityVerificationMethod] ON
INSERT [hipsui].[IdentityVerificationMethod] ([IdentityVerificationMethodId], [Code], [Description], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, N'IdentityVerificationMethod1', N'Attending third or more consultation and Medicare/DVA card', 1, 1, CAST(0x00009CF100000000 AS DateTime), N'', CAST(0x00009CF100000000 AS DateTime), N'')
INSERT [hipsui].[IdentityVerificationMethod] ([IdentityVerificationMethodId], [Code], [Description], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, N'IdentityVerificationMethod2', N'Attending hospital with their clinical referral and Medicare/DVA card', 2, 1, CAST(0x00009CF100000000 AS DateTime), N'', CAST(0x00009CF100000000 AS DateTime), N'')
INSERT [hipsui].[IdentityVerificationMethod] ([IdentityVerificationMethodId], [Code], [Description], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, N'IdentityVerificationMethod3', N'Attending emergency department with PHOTO ID with Medicare/DVA card', 3, 1, CAST(0x00009CF100000000 AS DateTime), N'', CAST(0x00009CF100000000 AS DateTime), N'')
INSERT [hipsui].[IdentityVerificationMethod] ([IdentityVerificationMethodId], [Code], [Description], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, N'IdentityVerificationMethod4', N'Having prescriptions filled on three or more occasions in the past year and Medicare/DVA card', 4, 1, CAST(0x00009CF100000000 AS DateTime), N'', CAST(0x00009CF100000000 AS DateTime), N'')
INSERT [hipsui].[IdentityVerificationMethod] ([IdentityVerificationMethodId], [Code], [Description], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, N'IdentityVerificationMethod5', N'Enrolled and attending Aboriginal Medical Service and Medicare/DVA card', 5, 1, CAST(0x00009CF100000000 AS DateTime), N'', CAST(0x00009CF100000000 AS DateTime), N'')
INSERT [hipsui].[IdentityVerificationMethod] ([IdentityVerificationMethodId], [Code], [Description], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, N'IdentityVerificationMethod6', N'Attending third or more consultation and has a My eHealth Record', 6, 1, CAST(0x00009CF100000000 AS DateTime), N'', CAST(0x00009CF100000000 AS DateTime), N'')
INSERT [hipsui].[IdentityVerificationMethod] ([IdentityVerificationMethodId], [Code], [Description], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, N'IdentityVerificationMethod7', N'Identity verified by referee consistent with My eHealth Record requirements', 7, 1, CAST(0x00009CF100000000 AS DateTime), N'', CAST(0x00009CF100000000 AS DateTime), N'')
INSERT [hipsui].[IdentityVerificationMethod] ([IdentityVerificationMethodId], [Code], [Description], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, N'IdentityVerificationMethod8', N'Resident of Aged Care facility and Medicare/DVA card', 8, 1, CAST(0x00009CF100000000 AS DateTime), N'', CAST(0x00009CF100000000 AS DateTime), N'')
INSERT [hipsui].[IdentityVerificationMethod] ([IdentityVerificationMethodId], [Code], [Description], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, N'IdentityVerificationMethod9', N'100pts of documentary evidence consistent with PCEHR Consumer Identity Framework', 9, 1, CAST(0x00009CF100000000 AS DateTime), N'', CAST(0x00009CF100000000 AS DateTime), N'')
INSERT [hipsui].[IdentityVerificationMethod] ([IdentityVerificationMethodId], [Code], [Description], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, N'IdentityVerificationMethod10', N'Other criteria approved by the System Operator', 10, 1, CAST(0x00009CF100000000 AS DateTime), N'', CAST(0x00009CF100000000 AS DateTime), N'')
SET IDENTITY_INSERT [hipsui].[IdentityVerificationMethod] OFF

TRUNCATE TABLE [hipsui].[IndigenousStatus]

SET IDENTITY_INSERT [hipsui].[IndigenousStatus] ON
INSERT [hipsui].[IndigenousStatus] ([IndigenousStatusId], [Code], [Description], [DisplayOrder], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, N'NeitherAboriginalAndTorresStraitIslander', N'No', 1, GETDATE(), N'', GETDATE(), N'')
INSERT [hipsui].[IndigenousStatus] ([IndigenousStatusId], [Code], [Description], [DisplayOrder], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, N'AboriginalNotTorresStraitIslander', N'Yes, Aboriginal', 2, GETDATE(), N'', GETDATE(), N'')
INSERT [hipsui].[IndigenousStatus] ([IndigenousStatusId], [Code], [Description], [DisplayOrder], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, N'TorresStraitIslanderNotAboriginal', N'Yes, Torres Strait Islander', 3, GETDATE(), N'', GETDATE(), N'')
INSERT [hipsui].[IndigenousStatus] ([IndigenousStatusId], [Code], [Description], [DisplayOrder], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, N'BothAboriginalAndTorresStraitIslander', N'Yes, Aboriginal and Torres Strait Islander', 4, GETDATE(), N'', GETDATE(), N'')
INSERT [hipsui].[IndigenousStatus] ([IndigenousStatusId], [Code], [Description], [DisplayOrder], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, N'NotStatedInadequatelyDescribed', N'Not Stated', 5, GETDATE(), N'', GETDATE(), N'')
SET IDENTITY_INSERT [hipsui].[IndigenousStatus] OFF

TRUNCATE TABLE [hipsui].[IvcDeliveryMethod]

SET IDENTITY_INSERT [hipsui].[IvcDeliveryMethod] ON
INSERT [hipsui].[IvcDeliveryMethod] ([IvcDeliveryMethodId], [Code], [Description], [RequiresDestination], [RequiresDestinationConfirm], [DestinationLabel], [ValidationRegex], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified], [DisplayOrder]) VALUES (1, N'response', N'Display the IVC', 0, 0, NULL, N'', 1, GETDATE(), N'Admin', GETDATE(), N'Admin', 1)
INSERT [hipsui].[IvcDeliveryMethod] ([IvcDeliveryMethodId], [Code], [Description], [RequiresDestination], [RequiresDestinationConfirm], [DestinationLabel], [ValidationRegex], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified], [DisplayOrder]) VALUES (2, N'sms', N'Send the IVC by SMS to: ', 1, 0, N'Mobile Number', N'', 1, GETDATE(), N'Admin', GETDATE(), N'Admin', 2)
INSERT [hipsui].[IvcDeliveryMethod] ([IvcDeliveryMethodId], [Code], [Description], [RequiresDestination], [RequiresDestinationConfirm], [DestinationLabel], [ValidationRegex], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified], [DisplayOrder]) VALUES (3, N'email', N'Send the IVC by Email to: ', 1, 0, N'Email', N'', 1, GETDATE(), N'Admin', GETDATE(), N'Admin', 3)
INSERT [hipsui].[IvcDeliveryMethod] ([IvcDeliveryMethodId], [Code], [Description], [RequiresDestination], [RequiresDestinationConfirm], [DestinationLabel], [ValidationRegex], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified], [DisplayOrder]) VALUES (4, N'mail', N'Send the IVC by Mail to the address held by Medicare', 0, 0, NULL, N'', 0, GETDATE(), N'Admin', GETDATE(), N'Admin', 4)
INSERT [hipsui].[IvcDeliveryMethod] ([IvcDeliveryMethodId], [Code], [Description], [RequiresDestination], [RequiresDestinationConfirm], [DestinationLabel], [ValidationRegex], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified], [DisplayOrder]) VALUES (5, N'none', N'Do not retrieve or send the IVC', 0, 0, NULL, N'', 1, GETDATE(), N'Admin', GETDATE(), N'Admin', 5)
SET IDENTITY_INSERT [hipsui].[IvcDeliveryMethod] OFF

TRUNCATE TABLE [hipsui].[MedicareConsent]

SET IDENTITY_INSERT [hipsui].[MedicareConsent] ON
INSERT [hipsui].[MedicareConsent] ([MedicareConsentId], [Code], [Description], [ParentMedicareConsentId], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, N'MBS', N'Medicare Benefits Schedule (MBS)', NULL, 1, 1, GETDATE(), N'Admin', GETDATE(), N'Admin')
INSERT [hipsui].[MedicareConsent] ([MedicareConsentId], [Code], [Description], [ParentMedicareConsentId], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, N'MBSPastAssimilation', N'AND details of any past claims for Medicare Benefits', 1, 1, 1, GETDATE(), N'Admin', GETDATE(), N'Admin')
INSERT [hipsui].[MedicareConsent] ([MedicareConsentId], [Code], [Description], [ParentMedicareConsentId], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, N'PBS', N'Pharmaceutical Benefits Scheme (PBS)', NULL, 2, 1, GETDATE(), N'Admin', GETDATE(), N'Admin')
INSERT [hipsui].[MedicareConsent] ([MedicareConsentId], [Code], [Description], [ParentMedicareConsentId], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, N'PBSPastAssimilation', N'AND details of any past claims for Pharmaceutical', 3, 1, 1, GETDATE(), N'Admin', GETDATE(), N'Admin')
INSERT [hipsui].[MedicareConsent] ([MedicareConsentId], [Code], [Description], [ParentMedicareConsentId], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, N'AODR', N'Australian Organ Donor Register (AODR)', NULL, 3, 1, GETDATE(), N'Admin', GETDATE(), N'Admin')
INSERT [hipsui].[MedicareConsent] ([MedicareConsentId], [Code], [Description], [ParentMedicareConsentId], [DisplayOrder], [IsEnabled], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, N'ACIR', N'Australian Childhood Immunisation Register (ACIR)', NULL, 4, 1, GETDATE(), N'Admin', GETDATE(), N'Admin')
SET IDENTITY_INSERT [hipsui].[MedicareConsent] OFF

TRUNCATE TABLE [hipsui].[Setting]

INSERT [hipsui].[Setting] ([Code], [Value], [SettingDescription], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (N'DefaultHospitalCodeSystem', N'pasFacCd', N'The default hospital code system used by the application.', GETDATE(), N'Admin', GETDATE(), N'Admin')
INSERT [hipsui].[Setting] ([Code], [Value], [SettingDescription], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (N'PcehrViewServiceDateDocumentClasses', N'18842-5', N'PCEHR View: CSV of document class codes for which service dates should be displayed. Used when displaying document metadata in the document lists.', GETDATE(), N'Admin', GETDATE(), N'Admin')
INSERT [hipsui].[Setting] ([Code], [Value], [SettingDescription], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (N'PcehrViewFromDateOffsetMonths', N'-24', N'PCEHR View: Negative integer value representing the number of months the "From" date criterion for the Prescription Dispense View will be offset from the current date by default.', GETDATE(), N'Admin', GETDATE(), N'Admin')
INSERT [hipsui].[Setting] ([Code], [Value], [SettingDescription], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (N'PcehrViewPDDocumentClasses', N'100.16764,100.16765', N'PCEHR View: CSV of document class codes for the Prescription and Dispense document classifications.', GETDATE(), N'Admin', GETDATE(), N'Admin')
INSERT [hipsui].[Setting] ([Code], [Value], [SettingDescription], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (N'PcehrViewPatientDaysDischarged', N'0', N'PCEHR View: The number of days since the patient has been discharged to still consider a patient to be "currently in hospital". Used when retrieving the list of patients currently in hospital.', GETDATE(), N'Admin', GETDATE(), N'Admin')

COMMIT TRANSACTION
GO
